<?php
include 'db_connect.php';

header("Content-Type: application/json; charset=UTF-8");

$semester_name = $_GET['semester'] ?? '';

if (empty($semester_name)) {
    echo json_encode(['status' => 'error', 'message' => 'El semestre es obligatorio.']);
    exit();
}

$semester_id_sql = "SELECT id FROM semesters WHERE name = ?";
$stmt_sem = $conn->prepare($semester_id_sql);
$stmt_sem->bind_param("s", $semester_name);
$stmt_sem->execute();
$semester_id_result = $stmt_sem->get_result();
$semester_id = $semester_id_result->fetch_assoc()['id'] ?? 0;
$stmt_sem->close();

if ($semester_id == 0) {
    echo json_encode([]); // Devuelve vacío si el semestre no existe
    exit();
}

// Súper consulta para traer todos los datos necesarios
$sql = "
    SELECT
        u.id as user_id,
        u.username,
        u.full_name,
        c.name AS course_name,
        c.professor,
        g.grade_name,
        g.grade_value
    FROM users u
    JOIN enrollments e ON u.id = e.user_id
    JOIN courses c ON e.course_id = c.id
    LEFT JOIN grades g ON e.id = g.enrollment_id AND g.user_id = e.user_id
    WHERE u.role = 'student' AND c.semester_id = ?
    ORDER BY u.full_name, c.name, g.id;
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $semester_id);
$stmt->execute();
$result = $stmt->get_result();

$report_data = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $user_id = $row['user_id'];
        
        // Si es la primera vez que vemos a este estudiante, lo añadimos
        if (!isset($report_data[$user_id])) {
            $report_data[$user_id] = [
                'fullName' => $row['full_name'],
                'username' => $row['username'],
                'courses' => []
            ];
        }

        $course_name = $row['course_name'];
        $course_key = -1;
        
        // Buscamos si el curso ya existe para este estudiante
        foreach($report_data[$user_id]['courses'] as $key => $course) {
            if ($course['name'] === $course_name) {
                $course_key = $key;
                break;
            }
        }

        // Si no existe, lo creamos
        if ($course_key == -1) {
             $report_data[$user_id]['courses'][] = [
                'name' => $row['course_name'],
                'professor' => $row['professor'],
                'grades' => []
            ];
            $course_key = count($report_data[$user_id]['courses']) - 1;
        }

        // Finalmente, añadimos la nota al curso correspondiente
        if ($row['grade_name'] != null) {
            $report_data[$user_id]['courses'][$course_key]['grades'][] = [
                'grade_name' => $row['grade_name'],
                'grade_value' => $row['grade_value']
            ];
        }
    }
}

$stmt->close();
$conn->close();

// Devolvemos el reporte como un array de estudiantes
echo json_encode(array_values($report_data));
?>