<?php
include 'db_connect.php';

header("Content-Type: application/json; charset=UTF-8");

// Obtenemos el usuario y semestre desde la URL (Query Parameters)
$username = $_GET['username'] ?? '';
$semester_name = $_GET['semester'] ?? '';

if (empty($username) || empty($semester_name)) {
    echo json_encode([]);
    exit();
}

// Buscamos el ID del usuario y del semestre
$user_id_sql = "SELECT id FROM users WHERE username = ?";
$stmt = $conn->prepare($user_id_sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$user_id_result = $stmt->get_result();
$user_id = $user_id_result->fetch_assoc()['id'] ?? 0;
$stmt->close();

$semester_id_sql = "SELECT id FROM semesters WHERE name = ?";
$stmt = $conn->prepare($semester_id_sql);
$stmt->bind_param("s", $semester_name);
$stmt->execute();
$semester_id_result = $stmt->get_result();
$semester_id = $semester_id_result->fetch_assoc()['id'] ?? 0;
$stmt->close();

if ($user_id == 0 || $semester_id == 0) {
    echo json_encode([]);
    exit();
}

// Consulta principal para obtener cursos y sus notas para un usuario y semestre
$sql = "
    SELECT
        c.name AS course_name,
        c.professor,
        c.description,
        g.id AS grade_id, -- <<< ¡AÑADIDO! Obtenemos el ID de la nota
        g.grade_name,
        g.grade_value
    FROM enrollments e
    JOIN courses c ON e.course_id = c.id
    LEFT JOIN grades g ON e.id = g.enrollment_id AND g.user_id = e.user_id
    WHERE e.user_id = ? AND c.semester_id = ?
    ORDER BY c.name, g.id;
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $user_id, $semester_id);
$stmt->execute();
$result = $stmt->get_result();

$courses_with_grades = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $course_name = $row['course_name'];

        if (!isset($courses_with_grades[$course_name])) {
            $courses_with_grades[$course_name] = [
                'name' => $row['course_name'],
                'professor' => $row['professor'],
                'description' => $row['description'],
                'grades' => []
            ];
        }

        if ($row['grade_id'] != null) {
            $courses_with_grades[$course_name]['grades'][] = [
                'id' => (int)$row['grade_id'], // <<< ¡AÑADIDO!
                'grade_name' => $row['grade_name'],
                'grade_value' => $row['grade_value']
            ];
        }
    }
}

$stmt->close();
$conn->close();

// Devolvemos un array de objetos, no un objeto de objetos
echo json_encode(array_values($courses_with_grades));
?>